using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmIssuedReturnedReport
	/// </summary>
	public class FrmIssuedReturnedReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.IssueReturnReport _report;
		
		#region form controls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvIssuedReturned;
		private System.ComponentModel.IContainer components = null;

		#endregion


		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="report"></param>
		public FrmIssuedReturnedReport(BOL.IssueReturnReport report)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			_report = report;

			SetComponentProperties();

			using (new WaitCursor())
			{
				this.CreateReport();
			}
		}

		#endregion


		#region methods

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmIssuedReturnedReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvIssuedReturned = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Issued/Returned Units Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 410);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvIssuedReturned
            // 
            this.rvIssuedReturned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvIssuedReturned.Location = new System.Drawing.Point(60, 37);
            this.rvIssuedReturned.Name = "rvIssuedReturned";
            this.rvIssuedReturned.Size = new System.Drawing.Size(579, 405);
            this.rvIssuedReturned.TabIndex = 6;
            // 
            // FrmIssuedReturnedReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvIssuedReturned);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Issued_Returned_Unit_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmIssuedReturnedReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Issued/Returned Units Report";
            this.Load += new System.EventHandler(this.FrmIssuedReturnedReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvIssuedReturned, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC076.FrmIssuedReturnedReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvIssuedReturned);
        }

		private void CreateReport()
		{
			DataSet dsReport = _report.CreateReport();
			DisplayReport(dsReport);
		}

		private void DisplayReport(DataSet reportData)
		{
			if (reportData == null || reportData.Tables.Count == 0)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("Report DataSet").ResString);
			}

#if DEBUG
			//reportData.Tables[0].WriteXml("e:\\temp\\IssuedReturnedDataSet.xml", XmlWriteMode.WriteSchema);
#endif
				// Populate parameters of report
				//_issueReturnReport.SetParameterValue("ReportTitle", "Issued/Returned Report");

			DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
			DataSet dsFooter = BOL.VbecsReport.GetReportFooter(_report.SearchCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (reportData.Tables.Count > 0)
            {
                reportSourceMain.Name = "IssuedReturnedDataSet";
                reportSourceMain.Value = reportData.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream;
            if (_report.SortByDate)
            {
                stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.IssueReturnUnits.IssuedReturnedDate.rdlc");
            }
            else
            {
                stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.IssueReturnUnits.IssuedReturnedPatient.rdlc");
            }

            this.rvIssuedReturned.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvIssuedReturned.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvIssuedReturned.LocalReport.DataSources.Add(reportSourceMain);
            this.rvIssuedReturned.LocalReport.LoadReportDefinition(stream);

            this.rvIssuedReturned.RefreshReport();

		}

		#endregion


		#region events

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvIssuedReturned.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		#endregion

        private void FrmIssuedReturnedReport_Load(object sender, EventArgs e)
        {

            this.rvIssuedReturned.RefreshReport();
        }

	}
}

